//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Globalization;

namespace FrameworkLibraries
{
	public class TimeZoneMain 
	{
		static void Main(string [] args)
		{
			TimeZone tz = TimeZone.CurrentTimeZone;
			Console.WriteLine("{0} {1}", tz.DaylightName, tz.StandardName);
			DaylightTime dt = tz.GetDaylightChanges(DateTime.Now.Year);
			Console.WriteLine("Pocztek czasu letniego {0}", dt.Start);
			Console.WriteLine("Koniec czasu letniego {0}", dt.End);
			Console.WriteLine("Zmiana czasu letniego {0}", dt.Delta);
			Console.WriteLine("Czy obecnie obowizuje czas letni? {0}", tz.IsDaylightSavingTime(DateTime.Now));
			Console.WriteLine("UTC {0}", tz.ToUniversalTime(DateTime.Now));
		}
	}
}